%% initialization
clear; clc;
addpath(('../Functions'))
%% loading Data:
Data = cell(5);
Data{1} = load("../Dataset/Data3.mat").X;
Data{2} = load("../Dataset/Data4.mat").X;
Data{3} = load("../Dataset/Data5.mat").X;
Data{4} = load("../Dataset/Data6.mat").X;
Data{5} = load("../Dataset/Data7.mat").X;

Data{1} = Data{1} + .001 * rand(size(Data{1}));
Data{2} = Data{2} + .001 * rand(size(Data{2}));
Data{3} = Data{3} + .001 * rand(size(Data{3}));
Data{4} = Data{4} + .001 * rand(size(Data{4}));
Data{5} = Data{5} + .001 * rand(size(Data{5}));


true_D = cell(5);
true_D{1} = load("../Dataset/D3.mat").true_D;
true_D{2} = load("../Dataset/D4.mat").true_D;
true_D{3} = load("../Dataset/D5.mat").true_D;
true_D{4} = load("../Dataset/D6.mat").true_D;
true_D{5} = load("../Dataset/D7.mat").true_D;


true_cov_mat = cell(5);
true_cov_mat{1} = load("../Dataset/cov_3.mat").true_cov;
true_cov_mat{2} = load("../Dataset/cov_4.mat").true_cov;
true_cov_mat{3} = load("../Dataset/cov_5.mat").true_cov;
true_cov_mat{4} = load("../Dataset/cov_6.mat").true_cov;
true_cov_mat{5} = load("../Dataset/cov_7.mat").true_cov;
%% output container:
result = cell(4,5);
%% Algorithm Parameters:
sigma = [.01, .05, .1, .3, 1, 10];
lambda = [.5, 1, 1.5, 2, 2.5, 3, 4, 4.5, 5];

%sigma = .05;
%lambda = 4.5;

Max_iterations = 3e4; MaxFunctionEvaluation = 3e6; sparsity = 2; N_try = 50; inner_loop_iter = 10;


temp_cell_1 = cell(size(sigma,1), size(lambda,1));
temp_cell_2 = cell(size(sigma,1), size(lambda,1));
temp_cell_3 = cell(size(sigma,1), size(lambda,1));
temp_cell_4 = cell(size(sigma,1), size(lambda,1));
temp_cell_5 = cell(size(sigma,1), size(lambda,1));

for k=1:5
    for i = 1:size(sigma,2)
        for j = 1:size(lambda,2)
            [D, cov_mat, err_D, err_cov, err_rec, counter] = algorithm(Max_iterations, MaxFunctionEvaluation, sparsity, N_try, inner_loop_iter, lambda(j), Data{k}, true_D{k}, true_cov_mat{k},sigma(i));
            temp_cell_1{i,j} =  err_D;
            temp_cell_2{i,j} = err_cov;
            temp_cell_3{i,j} = err_rec;
            temp_cell_4{i,j} = D;
            temp_cell_5{i,j} = cov_mat;
            disp("On Dataset number: " + string(k) +", Finished working on lambda: " + string(lambda(j)));
        end
        disp("On Dataset number: " + string(k) +", Finished working on sigma: " + string(sigma(i)));
    end
    disp("Finished working on Dataset: " + string(k));
    result{k,1} = temp_cell_1;
    result{k,2} = temp_cell_2;
    result{k,3} = temp_cell_3;
    result{k,4} = temp_cell_4;
    result{k,5} = temp_cell_5;
    
     
end

save("../Results/results.mat", "result");

